/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.v1_13_R2;

import com.andavin.reflect.Reflection;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.v1_13_R2.DataWatcherObject;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityItemFrame;
import net.minecraft.server.v1_13_R2.IMaterial;
import net.minecraft.server.v1_13_R2.ItemStack;
import net.minecraft.server.v1_13_R2.Items;
import net.minecraft.server.v1_13_R2.MathHelper;
import net.minecraft.server.v1_13_R2.Packet;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_13_R2.PacketPlayOutMap;
import net.minecraft.server.v1_13_R2.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_13_R2.PlayerConnection;
import net.minecraft.server.v1_13_R2.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;

class MapHelper
extends com.andavin.images.MapHelper {
    static final int DEFAULT_STARTING_ID = 1000000;
    private static final Field ENTITY_ID = Reflection.findField(Entity.class, "id");
    private static final DataWatcherObject<Integer> ROTATION = (DataWatcherObject)Reflection.getFieldValue(EntityItemFrame.class, null, "f");
    private static final Map<UUID, AtomicInteger> MAP_IDS = new HashMap<UUID, AtomicInteger>(4);

    MapHelper() {
    }

    @Override
    protected MapView getWorldMap(int id) {
        return Bukkit.getMap((int)id);
    }

    @Override
    protected int nextMapId(org.bukkit.World world) {
        return MAP_IDS.computeIfAbsent(world.getUID(), __ -> new AtomicInteger(1000000)).getAndIncrement();
    }

    @Override
    protected void createMap(int frameId, int mapId, Player player, Location location, BlockFace direction, int rotation, byte[] pixels) {
        ItemStack item = new ItemStack((IMaterial)Items.FILLED_MAP);
        item.getOrCreateTag().setInt("map", mapId);
        EntityItemFrame frame = new EntityItemFrame((World)((CraftWorld)player.getWorld()).getHandle());
        frame.setItem(item, false, false);
        this.setLocation(frame, location.getX(), location.getY(), location.getZ());
        frame.setDirection(CraftBlock.blockFaceToNotch((BlockFace)direction));
        Reflection.setFieldValue(ENTITY_ID, frame, frameId);
        if (rotation != 0) {
            frame.getDataWatcher().set(ROTATION, (Object)rotation);
        }
        PlayerConnection connection = ((CraftPlayer)player).getHandle().playerConnection;
        connection.sendPacket((Packet)new PacketPlayOutSpawnEntity((Entity)frame, 71, frame.getDirection().a(), frame.getBlockPosition()));
        connection.sendPacket((Packet)new PacketPlayOutEntityMetadata(frame.getId(), frame.getDataWatcher(), true));
        connection.sendPacket((Packet)new PacketPlayOutMap(mapId, 3, false, Collections.emptyList(), pixels, 0, 0, 128, 128));
    }

    @Override
    protected void destroyMap(Player player, int[] frameIds) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityDestroy(frameIds));
    }

    @Override
    protected byte[] createPixels(BufferedImage image) {
        int pixelCount = image.getWidth() * image.getHeight();
        int[] pixels = new int[pixelCount];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        byte[] colors = new byte[pixelCount];
        for (int i = 0; i < pixelCount; ++i) {
            colors[i] = MapPalette.matchColor((Color)new Color(pixels[i], true));
        }
        return colors;
    }

    private void setLocation(EntityItemFrame entity, double x, double y, double z) {
        entity.locX = MathHelper.a((double)x, (double)-3.0E7, (double)3.0E7);
        entity.locY = y;
        entity.locZ = MathHelper.a((double)z, (double)-3.0E7, (double)3.0E7);
        entity.lastX = entity.locX;
        entity.lastY = entity.locY;
        entity.lastZ = entity.locZ;
        entity.yaw = 0.0f;
        entity.pitch = 0.0f;
        entity.lastYaw = entity.yaw;
        entity.lastPitch = entity.pitch;
        double yawDiff = entity.lastYaw - 0.0f;
        if (yawDiff < -180.0) {
            entity.lastYaw += 360.0f;
        }
        if (yawDiff >= 180.0) {
            entity.lastYaw -= 360.0f;
        }
        entity.setPosition(entity.locX, entity.locY, entity.locZ);
    }
}

